# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from builtins import range
import logging
from functools import wraps

from django.db import connection
from django.db.utils import DatabaseError
from MySQLdb import OperationalError

log = logging.getLogger(__name__)
mysql_tries_id = 0

MAX_TRIES = 5


def mysql_try_hard(func):

    @wraps(func)
    def wrapper(*args, **kwargs):
        global mysql_tries_id

        mysql_tries_id += 1

        for tries_left in reversed(list(range(MAX_TRIES))):
            try:
                return func(*args, **kwargs)
            except (OperationalError, DatabaseError) as e:
                real_connection = connection.connection

                if real_connection:
                    at = real_connection.get_host_info()
                else:
                    at = '<unknown host>'

                log.error("in %d at %s: %s" % (mysql_tries_id, at, e))

                # Потеряна связь с мускулем
                # Пытаемся еще несколько раз, потом умираем
                if e.args[0] in [2003, 2006, 2013] and tries_left > 0:
                    log.info("%d tries left", tries_left)

                    connection.close()
                else:
                    raise

    return wrapper
