# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.library.python.common23.dynamic_settings.core import DynamicSetting
from travel.rasp.library.python.common23.dynamic_settings.default import conf


conf.register_settings(
    SUBURBAN_APP_AUTO_UPDATE_INTERVAL=DynamicSetting(
        120, cache_time=2 * 60,
        description='Как часто приложение Электрички пытается обновлять реалтайм-данные (сек) '),
)

conf.register_settings(
    AEROEX_BALANCE_LIMIT=DynamicSetting(
        -3900000, cache_time=60,
        description='Минимально допустимый лимит продаж')
)

conf.register_settings(
    EXPORT_TRAIN_SUBTYPE_POSTFIX=DynamicSetting(
        '<br/>(билеты&nbsp;c указанием&nbsp;мест)', cache_time=2 * 60,
        description='Добавка к подтипу транспорта для поездов'),
)

conf.register_settings(
    UGC_NOTIFICATION_SCHEDULED_TIME_SEND_SECONDS=DynamicSetting(
        1800, cache_time=2 * 60,
        description='Количество секунд, запланированное для отправки пуша после обнаружения станции поблизости'
    )
)

conf.register_settings(
    UGC_NOTIFICATION_TIMEOUT_SECONDS=DynamicSetting(
        7200, cache_time=2 * 60,
        description='Количество секунд, в течение которого не отправляем пуши после отправки пуша'
    )
)

conf.register_settings(
    UGC_STATION_NEAR_DISTANCE_METRES=DynamicSetting(
        1000, cache_time=2 * 60,
        description='Расстояние в метрах между текущей локацией и станцией, в радиусе которой отправляем пуш'
    )
)

conf.register_settings(
    SUBURBAN_PROMO_SEARCH=DynamicSetting(
        True, cache_time=120,
        description='Показывать промобаннер на поиске https://st.yandex-team.ru/RASPFRONT-7691'),
)

conf.register_settings(
    SUBURBAN_PROMO_FAVORITES=DynamicSetting(
        True, cache_time=120,
        description='Показывать промобаннер в избранном https://st.yandex-team.ru/RASPFRONT-7691'),
)

conf.register_settings(
    SUBURBAN_PROMO_STATION=DynamicSetting(
        True, cache_time=120,
        description='Показывать промобаннер на странице станции https://st.yandex-team.ru/RASPFRONT-7691'),
)

conf.register_settings(
    SUBURBAN_INFO_BANNER=DynamicSetting(
        False, cache_time=2 * 60,
        description='Показывать инфобаннер в приложении Электрички https://st.yandex-team.ru/RASPFRONT-8045'
    )
)

conf.register_settings(
    SUBURBAN_DRIVE_INTEGRATION=DynamicSetting(
        False, cache_time=2 * 60,
        description='Показывать интеграцию Драйва в приложении Электрички https://st.yandex-team.ru/RASPFRONT-8152'
    )
)

conf.register_settings(
    SUBURBAN_MUSIC_INTEGRATION=DynamicSetting(
        False, cache_time=2 * 60,
        description='Показывать интеграцию Яндекс.Музыки в приложении Электрички '
                    'https://st.yandex-team.ru/RASPFRONT-8293'
    )
)

conf.register_settings(
    SUBURBAN_SELLING__AEROEX_TARIFFS_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='Отдавать в suburban_selling тарифы Аэроэкспресса'),
)

conf.register_settings(
    SUBURBAN_SELLING__AEROEX_ORDER_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='Разрешить в suburban_selling создавать заказ Аэроэкспресса'),
)

conf.register_settings(
    SUBURBAN_AEROEX_SELLING_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='Показывать кнопку продажи для сегментов Аэроэкспресса. Используется только в приложении'),
)

conf.register_settings(
    SUBURBAN_SELLING__MOVISTA_TARIFFS_ENABLED=DynamicSetting(
        False, cache_time=60,
        description='Отдавать в suburban_selling тарифы Мовисты'),
)

conf.register_settings(
    SUBURBAN_SELLING__MOVISTA_API_CALL_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='suburban_selling - ходить ли в АПИ Мовисты за тарифами. Если выключено, то тарифы из кэша могут все равно отдаваться'),
)

conf.register_settings(
    SUBURBAN_SELLING__MOVISTA_ORDER_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='Разрешить в suburban_selling создавать заказ Мовисты'),
)

conf.register_settings(
    SUBURBAN_MOVISTA_SELLING_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='(Android) Показывать кнопку продажи для сегментов Мовисты'),
)

conf.register_settings(
    SUBURBAN_MOVISTA_SELLING_ENABLED_IOS=DynamicSetting(
        False, cache_time=60,
        description='(iOS) Показывать кнопку продажи для сегментов Мовисты'),
)

conf.register_settings(
    SUBURBAN_SELLING__IM_TARIFFS_ENABLED=DynamicSetting(
        False, cache_time=60,
        description='Отдавать в suburban_selling тарифы ИМ'),
)

conf.register_settings(
    SUBURBAN_SELLING__IM_API_CALL_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='suburban_selling - ходить ли в АПИ ИМ за тарифами. Если выключено, то тарифы из кэша могут все равно отдаваться'),
)

conf.register_settings(
    SUBURBAN_SELLING__IM_ORDER_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='Разрешить в suburban_selling создавать заказ ИМ'),
)

conf.register_settings(
    SUBURBAN_IM_SELLING_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='(Android) Показывать кнопку продажи для сегментов ИМ'),
)

conf.register_settings(
    SUBURBAN_IM_SELLING_ENABLED_IOS=DynamicSetting(
        True, cache_time=60,
        description='(iOS) Показывать кнопку продажи для сегментов ИМ'),
)

conf.register_settings(
    SUBURBAN_MTPPK_SELLING_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='Показывать кнопку продажи для сегментов МТППК'),
)

conf.register_settings(
    SUBURBAN_SZPPK_SELLING_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='Показывать кнопку продажи для сегментов СЗППК'),
)

conf.register_settings(
    SUBURBAN_BASHPPK_SELLING_ENABLED=DynamicSetting(
        False, cache_time=60,
        description='Показывать кнопку продажи для сегментов Башкортостанской ППК'),
)

conf.register_settings(
    SUBURBAN_SODRUZHESTVO_SELLING_ENABLED=DynamicSetting(
        False, cache_time=60,
        description='Показывать кнопку продажи для сегментов ППК Содружество'),
)

conf.register_settings(
    SUBURBAN_SELLING_ENABLE_APPLE_PAY=DynamicSetting(
        True, cache_time=60,
        description='(iOS) Разрешить продажу билетов через Apple Pay'),
)

conf.register_settings(
    SUBURBAN_SELLING_ENABLE_GOOGLE_PAY=DynamicSetting(
        True, cache_time=60,
        description='(Android) Разрешить продажу билетов через Google Pay'),
)

conf.register_settings(
    SUBURBAN_SELLING_ENABLE_PAYMENT_SDK_IOS=DynamicSetting(
        True, cache_time=60,
        description='(iOS) Разрешить продажу билетов через Payment SDK'),
)

conf.register_settings(
    SUBURBAN_SELLING_ENABLE_PAYMENT_SDK_ANDROID=DynamicSetting(
        True, cache_time=60,
        description='(Android) Разрешить продажу билетов через Payment SDK'),
)

conf.register_settings(
    SUBURBAN_POLLING_MAX_ORDERS_COUNT_IN_REQUEST=DynamicSetting(
        30, cache_time=60,
        description='Максимальное количество билетов, запрашиваемое за один раз при поллинге статусов списка заказов'),
)

conf.register_settings(
    SUBURBAN_POLLING_ORDERS_FIRST_TIME_STEP=DynamicSetting(
        2, cache_time=60,
        description='Длительность в секундах между первыми двумя вызовами при поллинге статусов списка заказов'),
)

conf.register_settings(
    SUBURBAN_POLLING_ORDERS_EXP_BACKOFF=DynamicSetting(
        1.5, cache_time=60,
        description='Шаг экспоненты поллинга статусов списка заказов'),
)

conf.register_settings(
    SUBURBAN_POLLING_ORDERS_MAX_CALLS_COUNT=DynamicSetting(
        25, cache_time=60,
        description='Максимальное количество вызовов при поллинге статусов списка заказов'),
)

conf.register_settings(
    SUBURBAN_POLLING_ORDERS_MAX_MINUTES_OFFSET=DynamicSetting(
        1440, cache_time=60,
        description='Максимальное время поллинга статусов списка заказов'),
)

conf.register_settings(
    SUBURBAN_POLLING_ORDERS_SHOW_SPINNER_TIME=DynamicSetting(
        180, cache_time=60,
        description='Как долго показываем юзеру крутилку при поллинге списка заказов'),
)

conf.register_settings(
    SUBURBAN_CAMERA_X_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='(Android) Включить камеру X'),
)

conf.register_settings(
    SUBURBAN_SELLING_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='Продажа билетов на электрички включена (отключать при проблемах с Трастом)'),
)

conf.register_settings(
    SUBURBAN_UPDATER_ENABLED=DynamicSetting(
        True, cache_time=60,
        description='(Android) Включить updater'),
)

conf.register_settings(
    SUBURBAN_UPDATER_URL=DynamicSetting(
        '', cache_time=60,
        description='(Android) URL для updater'),
)

conf.register_settings(
    SUBURBAN_LIB_SSL_ENABLED=DynamicSetting(
        False, cache_time=60,
        description='(Android) включение SSL через Яндексовские сертификаты'),
)

conf.register_settings(
    SUBURBAN_YANDEX_CA_CHALLENGE_HANDLER_ENABLED_IOS=DynamicSetting(
        True, cache_time=60,
        description='(iOS) Игнорировать отзыв YandexCA'),
)
