# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings

from travel.rasp.library.python.common23.db.mongo.mongo import databases
from travel.rasp.library.python.common23.date import environment

from travel.rasp.library.python.common23.dynamic_settings.core import Storage, NOTHING


class MongoStorage(Storage):
    def __init__(self):
        super(MongoStorage, self).__init__()
        self._dynamic_setting_db = None

    @property
    def dynamic_setting_db(self):
        if not self._dynamic_setting_db:
            self._dynamic_setting_db = databases[settings.DYNAMIC_SETTINGS_DATABASE_NAME]
        return self._dynamic_setting_db

    def get(self, setting_name):
        doc = self.dynamic_setting_db.dynamic_settings.find_one({'name': setting_name}, {'value': True})
        if not doc:
            return NOTHING

        return doc['value']

    def setup(self):
        self.dynamic_setting_db.dynamic_settings.create_index('name', background=True)

    def set(self, setting_name, value):
        self.dynamic_setting_db.dynamic_settings.update(
            {'name': setting_name},
            {'$set': {'value': value}},
            upsert=True,
        )

    def get_setting_info(self, setting_name):
        return self.dynamic_setting_db.dynamic_settings.find_one({'name': setting_name})


class MongoStorageWithHistory(MongoStorage):
    def set(self, setting_name, value):
        history = {
            'dt': environment.now(),
            'new_value': value,
            'context': self._saving_context
        }
        current_value = self.get(setting_name)
        if current_value is not NOTHING:
            history['current_value'] = current_value

        update_data = {
            '$set': {'value': value},
            '$push': {'history': history}
        }

        self.dynamic_setting_db.dynamic_settings.update(
            {'name': setting_name},
            update_data,
            upsert=True,
        )
