# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os

from travel.rasp.library.python.common23.utils.dcutils import ResourceExplorer


def configure_default_logging(settings, base_log_level=None, line_format=None,  jaeger_tracing=False):
    log_path = settings['LOG_PATH']

    if base_log_level is None:
        base_log_level = 'DEBUG' if settings['DEBUG'] else 'INFO'

    if line_format is None:
        line_format = '%(asctime)s %(process)d %(levelname)s %(name)s %(message)s %(context)s'

    if ResourceExplorer.is_run_in_deploy():
        json_error_formatter = json_formatter = 'travel.rasp.library.python.common23.logging.deploy.DeployJsonFormatter'
    else:
        json_formatter = 'travel.rasp.library.python.common23.logging.qloud.QloudJsonFormatter'
        json_error_formatter = 'travel.rasp.library.python.common23.logging.qloud.QloudExceptionFormatter'

    default_deploy_logging = {
        'version': 1,
        'disable_existing_loggers': False,
        'loggers': {
            '': {
                'handlers': ['application.log', 'deploy_stdout'],
                'level': base_log_level,
            },
            'django': {  # джанговые ошибки (от запросов) пишем отдельным форматом
                'handlers': ['exception.log', 'deploy_stderr'],
                'level': 'ERROR',
                'propagate': False,
            },
            'py.warnings': {
                'handlers': ['warnings.log', 'deploy_warnings_stdout'],
                'filters': ['unique_warnings'],
                'level': 'WARNING',
                'propagate': False,
            },
        },
        'handlers': {
            # to deploy
            'deploy_stdout': {
                'class': 'logging.StreamHandler',
                'filters': ['context_as_dict_filter'],
                'formatter': 'deploy_json_application',
                'stream': 'ext://sys.stdout',
            },
            'deploy_stderr': {
                'class': 'logging.StreamHandler',
                'filters': ['context_as_dict_filter'],
                'formatter': 'deploy_json_errors',
                'level': 'ERROR',
                'stream': 'ext://sys.stderr',
            },
            'deploy_warnings_stdout': {
                'class': 'logging.StreamHandler',
                'formatter': 'deploy_json_warnings',
                'level': 'WARNING',
                'stream': 'ext://sys.stdout',
            },

            # to files
            'application.log': {
                'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                'filters': ['context_filter'],
                'formatter': 'line',
                'level': base_log_level,
                'filename': os.path.join(log_path, 'application.log'),
            },
            'exception.log': {
                'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                'filters': ['context_filter'],
                'formatter': 'line_err',
                'level': 'ERROR',
                'filename': os.path.join(log_path, 'exception.log'),
            },
            'warnings.log': {
                'class': 'travel.rasp.library.python.common23.logging.WatchedFileHandler',
                'formatter': 'line',
                'level': 'WARNING',
                'filename': os.path.join(log_path, 'warnings.log'),
            }
        },
        'filters': {
            'context_filter': {
                '()': 'travel.rasp.library.python.common23.logging.AddContextFilter'
            },
            'context_as_dict_filter': {
                '()': 'travel.rasp.library.python.common23.logging.AddContextFilter',
                'as_dict': True
            },
            'unique_warnings': {
                '()': 'travel.rasp.library.python.common23.logging.WarningFilterOnce',
            },
        },
        'formatters': {
            'line': {
                'format': line_format,
            },
            'line_err': {
                '()': 'ylog.ExceptionFormatter',
                'format': line_format,
                'full': True,
                'show_locals': True,
            },
            'deploy_json_application': {
                '()': json_formatter,
                'tag': 'application',
            },
            'deploy_json_errors': {
                '()': json_error_formatter,
                'add_request_info': True,
                'tag': 'errors',
            },
            'deploy_json_warnings': {
                '()': json_formatter,
                'tag': 'warnings',
            }
        }
    }

    if jaeger_tracing:
        default_deploy_logging['loggers']['jaeger_tracing'] = {'level': 'WARNING'}

    return default_deploy_logging
