# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.library.python.common23.logging.base import BaseJsonFormatter


class DeployJsonFormatter(BaseJsonFormatter):
    def make_data(self, record):
        data = {
            'message': record.getMessage(),
            'level': record.levelno,
            'levelStr': record.levelname,
            'loggerName': record.name,
            'threadName': record.threadName,
        }
        if record.exc_info:
            data['stackTrace'] = self.formatException(record.exc_info)

        return data

    def make_std_fields(self, record):
        fields = {
            'file': {
                'pathname': record.pathname,
                'line': record.lineno,
                'funcName': record.funcName,
            },
            'module': record.module,
            'process': record.process,
            'processName': record.processName,
            'thread': record.thread,
        }

        return fields
