# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import traceback
from functools import wraps

log = logging.getLogger(__name__)


def logging_call_func(enabled=True, log_results=True, log_trace=True):
    def decorator(method):
        method_full_name = '{} from {}'.format(method.__name__, method.__module__)

        @wraps(method)
        def wrapper(*args, **kwargs):
            result = None
            error = None
            try:
                result = method(*args, **kwargs)
            except Exception as ex:
                error = ex
                raise
            finally:
                if enabled:
                    result_msg = ''
                    trace_msg = ''
                    if log_results:
                        result_msg = '\nError: {}'.format(error) if error else '\nReturn value: {}'.format(result)
                    if log_trace:
                        trace_msg = '\nTraceback: {}'.format('\r\n'.join(traceback.format_stack()))
                    log.info('Called method %s with *args=%s, **kwargs=%s%s%s',
                             method_full_name, args, kwargs, result_msg, trace_msg)
            return result

        return wrapper
    return decorator
