# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from contextlib import contextmanager
from functools import wraps

from django.conf import settings

from travel.rasp.library.python.common23.settings.utils import define_setting
from travel.rasp.library.python.solomon import SolomonProgressReporter


define_setting('SCRIPTS_SOLOMON_PUSH_URL', default='http://localhost:8003/rasp_tasks/')
define_setting('SCRIPTS_SOLOMON_PUSH_ENABLED', default=True)


@contextmanager
def task_progress_report(name, **kwargs):
    if settings.SCRIPTS_SOLOMON_PUSH_ENABLED:
        solomon_reporter = SolomonProgressReporter(
            solomon_url=settings.SCRIPTS_SOLOMON_PUSH_URL,
            source=name,
            labels=kwargs
        )

        with solomon_reporter.context():
            yield
    else:
        yield


def report_progress(source, labels=None):
    labels = labels or {}

    def wrapper(f):
        @wraps(f)
        def actual_wrapper(*args, **kwargs):
            with task_progress_report(source, **labels):
                return f(*args, **kwargs)

        return actual_wrapper

    return wrapper
