# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os.path

import logging
import six
from logging.config import DictConfigurator

from django.utils.functional import cached_property

from travel.rasp.library.python.common23.db.mongo.mongo import databases
from travel.rasp.library.python.common23.logging import _DictFormatter

STDOUT_DEFALUT_FD = 1
STDERR_DEFALUT_FD = 2


class DangerousIndexesConfig(Exception):
    pass


# !!!! Logging hack
logging._srcfile = os.path.normcase(logging.log.__code__.co_filename)


class MongoHandler(logging.Handler):
    def __init__(self, dbalias='default', collection_name='default_logs_collection', level=logging.NOTSET,
                 indexes=None):
        """
        :param indexes: list of pymongo.IndexModel
        Warning!!! Не удаляйте индекс, пока не выпилили всех пользователей этого индекса.
        Для установки индексов, нужно добавить MongoHandler.ensure_indexes_from_config(settings.LOGGING) в app.ready хук
        """
        super(MongoHandler, self).__init__(level)
        self.dbalias = dbalias
        self.collection_name = collection_name
        self._dict_formatter = _DictFormatter()
        self.indexes = indexes

        self._ensure_background()

    def _ensure_background(self):
        if not self.indexes:
            return
        for index in self.indexes:
            if not index.document.get('background'):
                raise DangerousIndexesConfig('Index must be background')

    @classmethod
    def ensure_indexes_from_config(cls, logging_config):
        configurator = DictConfigurator(logging_config)
        for handler_name in configurator.config.get('handlers', {}):
            handler_config = configurator.config['handlers'][handler_name]
            if handler_config.get('class') and issubclass(cls, configurator.resolve(handler_config.get('class'))):
                configurator.configure_handler(handler_config).ensure_index()

    def ensure_index(self):
        if not self.indexes:
            index_names = []
        else:
            index_names = self.collection.create_indexes(self.indexes)
        if self.collection_name not in databases[self.dbalias].list_collection_names():
            return
        for index_name in self.collection.index_information():
            if index_name != '_id_' and index_name not in index_names:
                self.collection.drop_index(index_name)

    def emit(self, record):
        try:
            self.collection.insert_one(self.format(record))
        except Exception:
            self.handleError(record)

    @cached_property
    def collection(self):
        db = databases[self.dbalias]
        return db.get_collection(self.collection_name)

    def format(self, record):
        record_dict = self._dict_formatter.log_record_to_dict(record)
        if 'context' in record_dict and isinstance(record_dict['context'], dict):
            record_dict['context'] = {
                k: six.text_type(v) for k, v in record_dict['context'].items()
            }
        return record_dict
