# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function


import logging
from contextlib import contextmanager
from uuid import uuid4

from ylog.context import log_context

from travel.rasp.library.python.common23.logging.metrics import task_progress_report

log = logging.getLogger(__name__)


@contextmanager
def script_context(name, report_progress=True, **kwargs):
    script_run_id = uuid4().hex
    context_data = {'script_name': name, 'script_id': script_run_id}
    context_data.update(kwargs)
    with log_context(**context_data):
        log.info('Run script: %s', name)
        try:
            if report_progress:
                with task_progress_report(name):
                    yield
            else:
                yield
        except Exception:
            log.exception('Script finished with error: %s', name)
            exit(1)
        else:
            log.info('Script finished: %s', name)
