# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

import ylog
from django.conf import settings


log = logging.getLogger(__name__)


class ExtractRequestMiddleware(object):
    def clear_context(self):
        for key in ylog.context.get_log_context():
            ylog.context.pop_from_context(key)

    def process_request(self, request):
        self.clear_context()
        extractor = settings.PYLOGCTX_REQUEST_EXTRACTOR
        try:
            for key, value in extractor(request).items():
                ylog.context.put_to_context(key, value)
        except Exception:
            log.exception('Error in context extraction')

    def process_exception(self, *args, **kwargs):
        self.clear_context()

    def process_response(self, request, response):
        self.clear_context()
        return response
