# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.core.directions.direction_from_translate import DirectionFromTranslate
from travel.rasp.library.python.common23.models.core.directions.direction_translate import DirectionTranslate
from travel.rasp.library.python.common23.models.core.geo.station import Station
from travel.rasp.library.python.common23.models.precache.manager import PrecachingManager


class Direction(models.Model):
    """
    Внутренние направления для электричек, используются для расчетов направлений в расписании.
    Больше нигде отображаться не должны
    """
    title = models.CharField(verbose_name=_(u'название направления'),
                             max_length=100, blank=False)
    L_title = DirectionTranslate.get_L_method(key_field='title')
    title_from = models.CharField(verbose_name=_(u'название направления туда(от Москвы)'),
                                  max_length=100, blank=False)
    L_title_from = DirectionFromTranslate.get_L_method(key_field='title_from')
    title_to = models.CharField(verbose_name=_(u'название направления обратно(на Москву)'),
                                max_length=100, blank=False)
    L_title_to = DirectionFromTranslate.get_L_method(key_field='title_to')
    code = models.CharField(verbose_name=_(u'код направления'),
                            max_length=50, blank=False, null=False, unique=True)
    suburban_zone = models.ForeignKey("SuburbanZone", blank=True, null=True,
                                      verbose_name=_(u"пригородная зона"),
                                      help_text=_(u"пригородная зона, в которую входит направление"))

    objects = PrecachingManager(keys=['pk', 'code'])

    @property
    def title_gen(self):
        return self.title[:-2] + u'ого'

    @property
    def stations(self):
        return Station.objects.filter(hidden=False,
                                      directionmarker__direction=self).order_by('title')

    def __unicode__(self):
        return self.title

    class Meta(object):
        ordering = ('title',)
        verbose_name = _(u'направление')
        verbose_name_plural = _(u'направления')
        app_label = 'www'
        db_table = 'www_direction'
