# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.utils.translation import ugettext_lazy as _
from travel.rasp.library.python.common23.models.texts.i18n import AbstractTranslate


class DirectionFromTranslate(AbstractTranslate):
    """
    Переводы названий направлений туда (от Москвы) и обратно (на Москву)
    """
    @classmethod
    def get_keys(cls):
        from travel.rasp.library.python.common23.models.core.directions.direction import Direction
        from travel.rasp.library.python.common23.models.core.directions.direction_marker import DirectionMarker
        from travel.rasp.library.python.common23.models.core.schedule.rtstation import RTStation

        values = set(Direction.objects.values_list('title_from', flat=True))

        values = values.union(Direction.objects.values_list('title_to', flat=True))

        values = values.union(DirectionMarker.objects.values_list('title_from', flat=True))

        values = values.union(DirectionMarker.objects.values_list('title_to', flat=True))

        values = values.union(RTStation.objects.values_list('arrival_subdir', flat=True))

        return values.union(RTStation.objects.values_list('departure_subdir', flat=True))

    class Meta(object):
        ordering = ('value',)
        verbose_name = _(u'перевод названия направления туда и обратно')
        verbose_name_plural = _(u'переводы названий направлений туда и обратно')
        app_label = 'www'
        db_table = 'www_directionfromtranslate'
