# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.core.directions.direction import Direction
from travel.rasp.library.python.common23.models.core.directions.direction_from_translate import DirectionFromTranslate
from travel.rasp.library.python.common23.models.core.geo.station import Station


ARROW_CHOICES = (
    ('', _(u"не указано")),
    ('right', _(u"направо")),
    ('left', _(u"налево")),
    ('up', _(u"вверх")),
    ('down', _(u"вниз")),
    ('right-up', _(u"направо-вверх")),
    ('right-down', _(u"направо-вниз")),
    ('left-up', _(u"налево-вверх")),
    ('left-down', _(u"налево-вниз"))
)


class DirectionMarker(models.Model):
    u"""Пометка для направления(вершина графа направления)"""
    direction = models.ForeignKey(Direction, blank=False,
                                  verbose_name=_(u"направление"))
    station = models.ForeignKey(Station, blank=True,
                                verbose_name=_(u"станция"), null=True,
                                help_text=_(u"если станция не указана, то это стрелка"))
    title_from = models.CharField(verbose_name=_(u"туда"),
                                  max_length=100, blank=True, null=True,
                                  help_text=_(u"название направления туда(от Москвы)."
                                              u" Используется для определения направления на предыдущей"
                                              u" станции((от Москвы) на Катышку)"))
    L_title_from = DirectionFromTranslate.get_L_method(key_field='title_from')
    title_to = models.CharField(verbose_name=_(u"обратно"),
                                max_length=100, blank=True, null=True,
                                help_text=_(u"название направления обратно(на Москву)."
                                            u" Используется для определения направления на предыдущей"
                                            u" станции((на Москву) на Бутку)"))
    L_title_to = DirectionFromTranslate.get_L_method(key_field='title_to')
    order = models.IntegerField(verbose_name=_(u"порядок"), db_index=True)
    arrival_title_from = models.CharField(verbose_name=_(u"прибытие Туда"),
                                          max_length=100, blank=True, null=True,
                                          help_text=_(u"название направления туда(от Москвы)."
                                                      u" Используется для определения направления прибытия на текущей"
                                                      u" станции((от Москвы) на Катышку) иначе берется текст из Туда"))
    arrival_title_to = models.CharField(verbose_name=_(u"прибытие Обратно"),
                                        max_length=100, blank=True, null=True,
                                        help_text=_(u"название направления обратно(на Москву)."
                                                    u" Используется для определения направления прибытия"
                                                    u" на текущей станции((на Москву) на Бутку)"
                                                    u" иначе берется текст из Обратно"))
    prev = models.ForeignKey("DirectionMarker", blank=True, null=True,
                             verbose_name=_(u"предыдущая станция"),
                             related_name='next_set')
    next = models.ForeignKey("DirectionMarker", blank=True, null=True,
                             verbose_name=_(u"следующая станция"),
                             related_name='prev_set')
    # Задаем в mysql как
    arrow_type = models.CharField(verbose_name=_(u"тип ответвления"),
                                  choices=ARROW_CHOICES,
                                  max_length=100, null=True, blank=True)
    arrow_title = models.CharField(blank=True, null=True, max_length=100,
                                   verbose_name=_(u"название стрелки"))

    def save(self, **kwargs):
        self.arrow_type = self.arrow_type or None
        super(DirectionMarker, self).save(**kwargs)

    def __unicode__(self):
        return self.station and self.station.title or (u'-> ' + self.arrow_title)

    def direction_name(self):
        return self.direction.title

    direction_name.short_description = _(u"направление")

    class Meta(object):
        ordering = ('order',)
        verbose_name = _(u'маркер направления')
        verbose_name_plural = _(u'маркеры направлений')
        unique_together = (('direction', 'station'), ('direction', 'order'))
        app_label = 'www'
        db_table = 'www_directionmarker'
