# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.texts.i18n import AbstractTranslate


class DirectionTranslate(AbstractTranslate):
    """
    Переводы названий направлений
    """

    @classmethod
    def get_keys(cls):
        from travel.rasp.library.python.common23.models.core.directions.direction import Direction

        return set(Direction.objects.values_list('title', flat=True))

    class Meta(object):
        ordering = ('value',)
        verbose_name = _(u'перевод названия направления')
        verbose_name_plural = _(u'переводы названий направлений')
        app_label = 'www'
        db_table = 'www_directiontranslate'
