# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.core.directions.external_direction import ExternalDirection
from travel.rasp.library.python.common23.models.core.geo.station import Station
from travel.rasp.library.python.common23.models.fields import CodeCharField, TrimmedCharField


class ExternalDirectionMarker(models.Model):
    u"""Пометка для направления(вершина графа направления)"""
    external_direction = models.ForeignKey(ExternalDirection, blank=False,
                                           verbose_name=_(u"направление"))
    station = models.ForeignKey(Station, blank=False,
                                verbose_name=_(u"станция"))
    order = models.IntegerField(verbose_name=_(u"порядок"), db_index=True)

    zone = TrimmedCharField(verbose_name=_(u'тарифная зона'), max_length=10, null=True, blank=True)
    zgroup = TrimmedCharField(verbose_name=_(u'тарифная группа'), max_length=50, null=True, blank=True)
    zprice = TrimmedCharField(verbose_name=_(u'въезд в зону'), max_length=50, null=True, blank=True)
    zprice_inner = TrimmedCharField(verbose_name=_(u'проезд внутри зоны'), max_length=50, null=True, blank=True)
    zprice_exit = TrimmedCharField(verbose_name=_(u'выезд из зоны в соседнюю'), max_length=50, null=True, blank=True)
    branch = CodeCharField(verbose_name=_(u'ветка'), max_length=50, null=True, blank=True)

    def __unicode__(self):
        return self.station.title

    def direction_name(self):
        return self.direction.title

    direction_name.short_description = _(u"направление")

    class Meta(object):
        ordering = ('order',)
        verbose_name = _(u'маркер внешнего направления')
        verbose_name_plural = _(u'маркеры внешних направлений')
        unique_together = (('external_direction', 'station'),
                           ('external_direction', 'order'))
        app_label = 'www'
        db_table = 'www_externaldirectionmarker'
