# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from travel.rasp.library.python.common23.models.precache.storage import BasePrecacheStorage


class Station2Direction(BasePrecacheStorage):
    @classmethod
    def build_cache(cls):
        from travel.rasp.library.python.common23.models.core.directions.direction_marker import DirectionMarker

        return {
            dm.station_id: dm.direction_id
            for dm in DirectionMarker.objects.all()
        }

    @classmethod
    def get_direction(cls, station):
        from travel.rasp.library.python.common23.models.core.directions.direction import Direction

        if cls.is_precached():
            try:
                direction_id = cls._cache[station.id]
            except KeyError:
                return None

            return Direction.objects.get(id=direction_id)

        try:
            return Direction.objects.filter(directionmarker__station=station)[0]
        except IndexError:
            pass

        return None
