# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.precache.manager import PrecachingManager


class BaseDistrict(models.Model):
    title = models.CharField(_(u"название"), max_length=255, null=False, blank=False)

    settlement = models.ForeignKey('www.Settlement', null=True, blank=True, default=None,
                                   verbose_name=_(u"город"), related_name="districts")
    region = models.ForeignKey('www.Region', null=False, blank=False,
                               verbose_name=_(u"область"))
    _disputed_territory = models.BooleanField(verbose_name=_(u"спорная территория"), default=False,
                                              db_column='disputed_territory')

    objects = PrecachingManager(keys=['pk'])

    class Meta(object):
        abstract = True
        app_label = 'www'
        db_table = 'www_district'
        verbose_name = _(u"район")
        verbose_name_plural = _(u"районы")

    def __unicode__(self):
        return (_(u"район %(district_title)s в %(region_title)s") %
                {'district_title': self.title, 'region_title': self.region.title})

    # RASP-11930
    def L_title_with_postfix(self, lang=None):
        # Заглушка. todo написать полный вариант
        return u"%s р-н" % self.title

    @property
    def disputed_territory(self):
        if self._disputed_territory:
            return True

        if self.region and self.region.disputed_territory:
            return True

        return self.settlement and self.settlement._disputed_territory
