# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.db import models
from django.utils.translation import ugettext_lazy as _
from travel.rasp.library.python.common23.utils.files.storage import YFStorage


class BaseSettlementImage(models.Model):
    settlement = models.ForeignKey('www.Settlement', verbose_name=u'Город', blank=True, null=True)

    img_orig = models.ImageField(verbose_name=_(u'Оригинальное изображение'),
                                 max_length=255,
                                 upload_to='default',
                                 storage=YFStorage(token=settings.FOTKI_API_INTERCITY_TOKEN,
                                                   user=settings.FOTKI_API_INTERCITY_LOGIN,
                                                   album=settings.INTERCITY_ORIG_IMAGE_ALBUM))

    img_1140 = models.ImageField(verbose_name=_(u'Картинка 1140x772'),
                                 max_length=255,
                                 blank=True,
                                 default='',
                                 upload_to='default',
                                 storage=YFStorage(token=settings.FOTKI_API_INTERCITY_TOKEN,
                                                   user=settings.FOTKI_API_INTERCITY_LOGIN,
                                                   album=settings.INTERCITY_IMAGE_SIZE_ALBUMS['1140x772']))

    img_1080 = models.ImageField(verbose_name=_(u'Картинка 1080x579'),
                                 max_length=255,
                                 blank=True,
                                 default='',
                                 upload_to='default',
                                 storage=YFStorage(token=settings.FOTKI_API_INTERCITY_TOKEN,
                                                   user=settings.FOTKI_API_INTERCITY_LOGIN,
                                                   album=settings.INTERCITY_IMAGE_SIZE_ALBUMS['1080x579']))

    img_720 = models.ImageField(verbose_name=_(u'Картинка 720x386'),
                                max_length=255,
                                blank=True,
                                default='',
                                upload_to='default',
                                storage=YFStorage(token=settings.FOTKI_API_INTERCITY_TOKEN,
                                                  user=settings.FOTKI_API_INTERCITY_LOGIN,
                                                  album=settings.INTERCITY_IMAGE_SIZE_ALBUMS['720x386']))

    img_540 = models.ImageField(verbose_name=_(u'Картинка 540x290'),
                                max_length=255,
                                blank=True,
                                default='',
                                upload_to='default',
                                storage=YFStorage(token=settings.FOTKI_API_INTERCITY_TOKEN,
                                                  user=settings.FOTKI_API_INTERCITY_LOGIN,
                                                  album=settings.INTERCITY_IMAGE_SIZE_ALBUMS['540x290']))

    img_360 = models.ImageField(verbose_name=_(u'Картинка 360x193'),
                                max_length=255,
                                blank=True,
                                default='',
                                upload_to='default',
                                storage=YFStorage(token=settings.FOTKI_API_INTERCITY_TOKEN,
                                                  user=settings.FOTKI_API_INTERCITY_LOGIN,
                                                  album=settings.INTERCITY_IMAGE_SIZE_ALBUMS['360x193']))

    img_164 = models.ImageField(verbose_name=_(u'Картинка 164x164'),
                                max_length=255,
                                blank=True,
                                default='',
                                upload_to='default',
                                storage=YFStorage(token=settings.FOTKI_API_INTERCITY_TOKEN,
                                                  user=settings.FOTKI_API_INTERCITY_LOGIN,
                                                  album=settings.INTERCITY_IMAGE_SIZE_ALBUMS['164x164']))

    img_123 = models.ImageField(verbose_name=_(u'Картинка 123x123'),
                                max_length=255,
                                blank=True,
                                default='',
                                upload_to='default',
                                storage=YFStorage(token=settings.FOTKI_API_INTERCITY_TOKEN,
                                                  user=settings.FOTKI_API_INTERCITY_LOGIN,
                                                  album=settings.INTERCITY_IMAGE_SIZE_ALBUMS['123x123']))

    img_82 = models.ImageField(verbose_name=_(u'Картинка 82x82'),
                               max_length=255,
                               blank=True,
                               default='',
                               upload_to='default',
                               storage=YFStorage(token=settings.FOTKI_API_INTERCITY_TOKEN,
                                                 user=settings.FOTKI_API_INTERCITY_LOGIN,
                                                 album=settings.INTERCITY_IMAGE_SIZE_ALBUMS['82x82']))

    img_62 = models.ImageField(verbose_name=_(u'Картинка 62x62'),
                               max_length=255,
                               blank=True,
                               default='',
                               upload_to='default',
                               storage=YFStorage(token=settings.FOTKI_API_INTERCITY_TOKEN,
                                                 user=settings.FOTKI_API_INTERCITY_LOGIN,
                                                 album=settings.INTERCITY_IMAGE_SIZE_ALBUMS['62x62']))

    img_41 = models.ImageField(verbose_name=_(u'Картинка 62x62'),
                               max_length=255,
                               blank=True,
                               default='',
                               upload_to='default',
                               storage=YFStorage(token=settings.FOTKI_API_INTERCITY_TOKEN,
                                                 user=settings.FOTKI_API_INTERCITY_LOGIN,
                                                 album=settings.INTERCITY_IMAGE_SIZE_ALBUMS['41x41']))

    class Meta(object):
        abstract = True
        verbose_name = _(u'Изображение города')
        verbose_name_plural = _(u'Изображение городов')
        app_label = 'api'
        db_table = 'api_settlementimage'

    @classmethod
    def get_image_formats(cls):
        """
        Метод кэширует и возвращает возможные форматы изображений
        """

        if not hasattr(cls, '_FORMATS'):
            cls._FORMATS = [
                f.attname[4:] for f in cls._meta.get_fields()
                if f.concrete and f.attname.startswith('img_')
            ]

        return cls._FORMATS

    @classmethod
    def get_image_for_settlement(cls, settlement):
        try:
            return cls.objects.filter(settlement=settlement)[0]
        except IndexError:
            return None

    @classmethod
    def get_image_url_for_settlement(cls, settlement, image_format):
        if image_format not in cls.get_image_formats():
            return None

        image_object = cls.get_image_for_settlement(settlement)
        image = getattr(image_object, 'img_{}'.format(image_format), None)

        return image.url if image else None

    def __unicode__(self):
        if self.settlement:
            return u'Картинка для {}'.format(self.settlement)

        return u'Заглушка'
