# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _


class CityMajority(models.Model):
    """ Важность города: столица, деревня, ... """

    title = models.CharField(verbose_name=_(u'наименование'), max_length=100)

    COMMON_CITY_ID = 4
    POPULATION_MILLION_ID = 3
    CAPITAL_ID = 1
    REGION_CAPITAL_ID = 2

    def __unicode__(self):
        return self.title

    class Meta(object):
        verbose_name = _(u'важность города')
        verbose_name_plural = _(u'важности городов')
        app_label = 'www'
        db_table = 'www_citymajority'
