# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import six

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.fields import CodeCharField
from travel.rasp.library.python.common23.models.precache.manager import PrecachingManager


@six.python_2_unicode_compatible
class CodeSystem(models.Model):
    u"""Система кодирования"""
    title = models.CharField(verbose_name=_(u'название системы кодирования'),
                             max_length=100, blank=False)
    code = CodeCharField(verbose_name=_(u'код системы кодирования'),
                         max_length=100, blank=False, unique=True)

    objects = PrecachingManager(keys=['pk', 'code'])

    def __str__(self):
        return six.text_type(self.title)

    class Meta(object):
        ordering = ('id',)
        verbose_name = _(u'система кодирования')
        verbose_name_plural = _(u'cистемы кодирования')
        app_label = 'www'
        db_table = 'www_codesystem'

    # Константы для разных типов
    EXPRESS_ID = 2
