# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.contrib.contenttypes.fields import GenericForeignKey
from django.contrib.contenttypes.models import ContentType
from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.fields import CodeCharField


class PointSynonym(models.Model):
    title = models.CharField(_(u'синоним'), max_length=100)
    content_type = models.ForeignKey(ContentType, limit_choices_to={'app_label': 'www',
                                                                    'model__in': ('station', 'settlement', 'country')})
    object_id = models.PositiveIntegerField()
    point = GenericForeignKey()

    language = CodeCharField(
        _(u'язык синонима'),
        max_length=5,
        choices=[(lang, _(lang)) for lang in settings.SUGGEST_LANGUAGES],
        null=True,
        blank=True,
    )

    search_type = models.CharField(max_length=20, null=False, editable=False, default='synonym', db_index=True,
                                   choices=[
                                       ('synonym', _(u'синоним')),
                                       ('normalized', _(u'нормализованная форма')),
                                       ('tokenized', _(u'токены')),
                                       ('exact', _(u'точная копия'))
                                   ])

    def __unicode__(self):
        return self.title

    class Meta(object):
        verbose_name = _(u'синоним')
        verbose_name_plural = _(u'синонимы')
        ordering = ('title',)
        app_label = 'www'
        db_table = 'www_pointsynonym'
