# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.precache.manager import PrecachingManager
from travel.rasp.library.python.common23.models.texts.i18n import L_field


class StationMajority(models.Model):
    """ Важность станции: главная в городе, ... """

    MAIN_IN_CITY_ID = 1
    IN_TABLO_ID = 2
    NOT_IN_TABLO_ID = 3
    STATION_ID = 4
    NOT_IN_SEARCH_ID = 5
    EXPRESS_FAKE_ID = 100
    MAX_ID = 100

    # TODO: старое название для совместимости с route_search. Нужно удалить,
    # когда фикс для бровары-киев будет всеми использоваться
    IN_TABLO = IN_TABLO_ID

    TANKER_L_FIELDS = ['title']

    L_title = L_field(_(u'наименование'))
    code = models.CharField(verbose_name=_(u'код для питона'), max_length=50,
                            editable=False)

    objects = PrecachingManager(keys=['pk', 'code'])

    def __unicode__(self):
        return self.L_title()

    def get_title(self):
        return self.L_title()

    title = property(get_title)

    class Meta(object):
        verbose_name = _(u'важность станции')
        verbose_name_plural = _(u'важности станций')
        app_label = 'www'
        db_table = 'www_stationmajority'
