# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.core.geo.station import Station


class StationPhone(models.Model):
    """ Телефон станции """

    station = models.ForeignKey(Station, verbose_name=_(u'станция'))
    phone = models.CharField(verbose_name=_(u'телефон'), max_length=255)
    note = models.TextField(verbose_name=_(u'примечание'),
                            null=True, blank=True, default=None)

    def __unicode__(self):
        return self.phone

    class Meta(object):
        verbose_name = _(u'телефон станции')
        verbose_name_plural = _(u'телефоны станций')
        ordering = ('phone',)
        app_label = 'www'
