# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.utils.functional import cached_property

from travel.rasp.library.python.common23.date import environment
from travel.rasp.library.python.common23.date.date import get_pytz, get_msk_time_zone, get_timezone_from_point
from travel.rasp.library.python.common23.date.date_const import MSK_TZ
from travel.rasp.library.python.common23.models.texts.geobase_ltitle import Geobase_L_title  # noqa


class TimeZoneMixin(object):
    # Переводит время без временной зоны из Мск в местное

    @cached_property
    def pytz(self):
        return get_pytz(self.get_tz_name())

    def utcoffset(self):
        return int(environment.now_aware().astimezone(self.pytz).utcoffset().total_seconds())

    def localize(self, msk=None, loc=None):
        if msk:
            if msk.tzinfo is None:
                msk = MSK_TZ.localize(msk)

                if self.pytz == MSK_TZ:
                    return msk

            return msk.astimezone(self.pytz)
        elif loc:
            if loc.tzinfo is None:
                return self.pytz.localize(loc)

            return loc.astimezone(self.pytz)

    def get_msk_datetime(self, loc):
        local_datetime = self.localize(loc=loc)
        return local_datetime.astimezone(MSK_TZ)

    def get_local_datetime(self, msk):
        return self.localize(msk=msk)

    def local_time(self, localized_dt):
        # FIXME: навание не соответствует типу
        return localized_dt.astimezone(self.pytz)

    def get_time_zone(self, **kwargs):
        """Возвращает временную зону с учетом контекстного времени

        Keyword Arguments:
        msk_datetime: Московское время, тип datetime
        local_datetime: местное время, тип datetime
        Одно из времен указать обязательно
        """
        return get_msk_time_zone(self, **kwargs)

    def get_time_zone_offset_from_msk_in_minutes(self, **kwargs):
        """Возвращает временную зону с учетом контекстного времени

        Keyword Arguments:
        msk_datetime: Московское время, тип datetime
        local_datetime: местное время, тип datetime
        Одно из времен указать обязательно
        """
        return get_msk_time_zone(self, **kwargs)

    def get_tz_name(self):
        return get_timezone_from_point(self)
