# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.utils.encoding import smart_str

from travel.rasp.library.python.common23.models.core.geo.point import Point  # noqa
from travel.rasp.library.python.common23.models.core.geo.timezone_mixin import TimeZoneMixin  # noqa
from travel.rasp.library.python.common23.models.texts.geobase_ltitle import Geobase_L_title  # noqa
from travel.rasp.library.python.common23.utils_db.geobase import geobase


log = logging.getLogger(__name__)


class TransLocalMixin(object):
    def _translocal_country(self, national_version):
        from travel.rasp.library.python.common23.models.core.geo.country import Country

        if not geobase:
            return

        geo_id = self.get_settlement_geo_id() or self.get_region_geo_id()

        if not geo_id:
            log.error('У спорного региона %s %s не нашли geo_id города или области',
                      self.id, self.__class__.__name__)
            return

        try:
            country_geo_id = geobase.find_country_id(geo_id, smart_str(national_version))

        except Exception:
            log.exception('Не удалось получить транслокальную страну для'
                          ' спорного региона %s национальная версия %s',
                          geo_id, national_version)
            return

        # Геобаза почему-то иногда возращает 0
        if country_geo_id == 0:
            log.error('Геобаза вернула geo_id == 0 для страны'
                      ' спорного региона %s национальная версия %s',
                      geo_id, national_version)
            return

        try:
            return Country.objects.get(_geo_id=country_geo_id)
        except Country.DoesNotExist:
            log.exception('Не нашли страну по geoid %s'
                          ' спорного города %s национальная версия %s',
                          country_geo_id, geo_id, national_version)

    def translocal_country(self, national_version=None):
        if not self.disputed_territory:
            return self.country

        if not national_version:
            return None

        return self._translocal_country(national_version)
