# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.core.geo.station import Station
from travel.rasp.library.python.common23.models.precache.manager import PrecachingManager
from travel.rasp.library.python.common23.models.texts.i18n import L_field


WAY_TYPE_CHOICES = (
    ('suburban', _('Электрички')),
    ('aeroexpress', _('Аэроэкспрессы'))
)


class WayToAirport(models.Model):
    """
    Данные для формирования ссылки на поиск электричек в аэропорт со станции
    """
    station = models.ForeignKey(Station, verbose_name=_(u'станция'), null=False, blank=False)
    L_title = L_field(_(u'Подпись ссылки'), base_lang='ru', max_length=100)

    from_station = models.ForeignKey(Station, verbose_name=_(u'станция отправления'),
                                     null=False, blank=False,
                                     related_name='from_ways_to_airport')
    to_station = models.ForeignKey(Station, verbose_name=_(u'станция прибытия'),
                                   null=False, blank=False,
                                   related_name='to_ways_to_airport')
    way_type = models.CharField(verbose_name=_(u'Тип пути в аэропорт'),
                                max_length=30,
                                choices=WAY_TYPE_CHOICES, default='aeroexpress')

    objects = PrecachingManager(keys=['pk', 'station'])

    class Meta(object):
        verbose_name = _(u'путь в аэропорт')
        verbose_name_plural = _(u'пути в аэропорт')
        app_label = 'www'
        db_table = 'www_waytoairport'
