# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.db.mds.s3_storage import mds_s3_media_storage
from travel.rasp.library.python.common23.models.texts.i18n import L_field


class AviaAlliance(models.Model):
    L_title = L_field(
        _(u'название альянса'), default=u'', max_length=100, blank=True,
        add_local_field=True, local_field_critical=True
    )

    logo_svg = models.FileField(verbose_name=u'SVG логотип',
                                storage=mds_s3_media_storage,
                                null=False, blank=True,
                                upload_to='data/alliance/logo')

    L_description = L_field(
        verbose_name=_(u"описание"), add_local_field=True,
        field_cls=models.TextField, blank=True
    )
    enabled = models.BooleanField(_(u'Показывать'), blank=False, null=False, default=False)

    class Meta(object):
        ordering = ('title',)
        verbose_name = _(u"авиа альянс")
        verbose_name_plural = _(u"авиа альянсы")
        app_label = 'www'

    def __unicode__(self):
        return self.L_title()
