# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _


class BaseRoute(models.Model):
    """ Рейс
    Фактически - это номер, и дополнительная общая информация для всех ниток.
    """

    t_type = models.ForeignKey('www.TransportType', verbose_name=_(u'тип транспорта'))
    comment = models.TextField(verbose_name=_(u'комментарий'),
                               null=True, blank=True, default=u"")
    supplier = models.ForeignKey('www.Supplier', verbose_name=_(u'поставщик'),
                                 null=False, blank=True,
                                 limit_choices_to={'hide_in_filters': False})
    # В базе данных содавать как `script_protected` bool NOT NULL DEFAULT FALSE
    script_protected = models.BooleanField(verbose_name=_(u"не менять при импорте"),
                                           null=False, default=True)
    # TODO: заменить просто на uid в базе
    route_uid = models.CharField(verbose_name=_(u"идентификатор"),
                                 help_text=_(u"идентификатор для однозначного "
                                             u"определения рейса из импорта"),
                                 max_length=100, null=False)
    hidden = models.BooleanField(verbose_name=_(u"рейс скрыт"), null=False,
                                 default=False)

    style = models.TextField(verbose_name=_(u'стиль линии метро'),
                             blank=True, default=None, null=True)
    modified_at = models.DateTimeField(_(u'Дата-время изменения'), auto_now=True, null=False, blank=True)

    class Meta(object):
        verbose_name = _(u'рейс')
        verbose_name_plural = _(u'рейсы')
        app_label = 'www'
        db_table = 'www_route'
        unique_together = (('route_uid', 't_type', 'supplier'),)
        abstract = True
