# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import warnings

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.db.mds.s3_storage import mds_s3_media_storage
from travel.rasp.library.python.common23.models.fields import CodeCharField, TrimmedCharField
from travel.rasp.library.python.common23.models.precache.manager import PrecachingManager
from travel.rasp.library.python.common23.models.texts.i18n import L_field
from travel.rasp.library.python.common23.models.utils import HiddenManagerWrapper
from travel.rasp.library.python.common23.utils.warnings import RaspDeprecationWarning


def get_svg2png_logo_upload_to(instance, filename):
    return 'data/company/svg2png/id%s.png' % instance.id


class Company(models.Model):
    """ Компания-перевозчик """

    CPPK_ID = 153
    AEROEXPRESS_ID = 162
    CPPK_AEROEX_ID = 63448
    SZPPK_ID = 1332
    MTPPK_ID = 1846
    SZPPK_MTPPK_ID = 8707
    BASHPPK_ID = 2871
    SODRUZHESTVO_ID = 2387
    SAMPPK_BASHPPK_ID = 5397

    address = models.CharField(verbose_name=_(u'адрес'), max_length=255, null=True,
                               blank=True)
    home_station = models.ForeignKey('www.Station', verbose_name=_(u'главная станция'),
                                     null=True, blank=True)

    supplier_code = CodeCharField(verbose_name=_(u'код Поставщика Данных'), max_length=255,
                                  null=True, blank=True, default=None, unique=True)
    sirena_id = CodeCharField(verbose_name=_(u'код Сирена'), max_length=100,
                              null=True, blank=True, default=None, unique=True)
    iata = CodeCharField(verbose_name=_(u'код IATA'), max_length=100,
                         null=True, blank=True, default=None, db_index=True)
    icao = CodeCharField(verbose_name=_(u'код ICAO'), max_length=100, null=True,
                         blank=True, unique=True)
    icao_ru = CodeCharField(verbose_name=_(u'код ICAO(рус)'), max_length=100, null=True,
                            blank=True, unique=True)
    express_code = CodeCharField(verbose_name=_(u'Код Express(рус)'), max_length=100, null=True,
                                 blank=True, unique=True)
    tis_code = CodeCharField(verbose_name=_('Код компании от ТИС'), max_length=20, null=True,
                             blank=True, unique=True, default=None)
    yandex_avia_code = CodeCharField(verbose_name=_('Код компании в avia.yandex.ru'), max_length=100, null=True,
                                     blank=True, unique=True, default=None)
    t_type = models.ForeignKey('www.TransportType', verbose_name=_(u'тип транспорта'),
                               null=True, blank=True, default=None)
    is_freight = models.BooleanField(_(u"Грузовая компания"), default=False,
                                     help_text=_(u"Не импортируем такие компании от OAG"))

    priority = models.IntegerField(
        null=False, blank=True, default=0,
        help_text=_(u'Приоритет для различения компаний с одним иата-кодом')
    )

    L_title = L_field(_(u'название'), add_local_field=True)
    L_short_title = L_field(_(u'краткое название'), add_local_field=True)

    url = models.URLField(verbose_name=_(u'урл сайта'), max_length=255, null=True,
                          blank=True)

    L_registration_url = L_field(_(u'Url регистрации'), add_local_field=True, default='', blank=True, null=True,
                                 max_length=255)
    L_registration_phone = L_field(_(u'Телефон регистрации'), add_local_field=True, default='', blank=True, null=True,
                                   max_length=255)

    email = models.EmailField(verbose_name=_(u'email'), max_length=255, null=True, blank=True)
    contact_info = models.TextField(verbose_name=_(u'контактная информация'),
                                    null=True, blank=True, default=None)
    phone = TrimmedCharField(verbose_name=_(u'контактный телефон'), max_length=255, null=False,
                             default='', blank=True)
    phone_booking = TrimmedCharField(verbose_name=_(u'телефон для бронирования'), max_length=255, null=False,
                                     default='', blank=True)
    description = models.TextField(verbose_name=_(u'описание'),
                                   null=True, blank=True, default=None)

    logo = models.ImageField(verbose_name=_(u'логотип'),
                             storage=mds_s3_media_storage,
                             upload_to='data/company/logo', null=True, blank=True,
                             default=None)
    icon = models.ImageField(verbose_name=_(u'иконка'),
                             storage=mds_s3_media_storage,
                             upload_to='data/company/icon',
                             null=True, blank=True, default=None)
    logo_mono = models.ImageField(verbose_name=_(u'логотип без фона'),
                                  storage=mds_s3_media_storage,
                                  upload_to='data/company/logo_mono',
                                  null=True, blank=True, default=None)

    logo_bgcolor = TrimmedCharField(verbose_name=_(u'цвет фона логотипа'), max_length=7, null=False,
                                    help_text=_(u'В формате #FF0044'),
                                    default='', blank=True)

    svg_logo = models.FileField(verbose_name=_(u'svg логотип'),
                                storage=mds_s3_media_storage,
                                upload_to='data/company/svg',
                                null=True, blank=True, default=None)

    svg2png_logo = models.ImageField(
        verbose_name=_(u'Рендеренный svg2png логотип'),
        upload_to=get_svg2png_logo_upload_to,
        storage=mds_s3_media_storage,
        null=True, blank=True, default=None
    )

    country = models.ForeignKey('www.Country', verbose_name=_(u'страна'),
                                null=True, blank=True, default=None)
    hidden = models.BooleanField(verbose_name=_(u'не показывать нигде!'), default=False)
    strange = models.BooleanField(verbose_name=_(u'не понятные перевозчики'),
                                  default=False)

    meta_title = models.CharField(max_length=255, verbose_name=_(u'meta title'), null=True, blank=True)
    meta_description = models.TextField(verbose_name=_(u'meta description'), null=True, blank=True)

    alliance = models.ForeignKey('AviaAlliance', verbose_name=_(u'Авиа-альянс'), null=True,
                                 blank=True, related_name='companies')

    L_bonus_name = L_field(_(u'название программы для часто летающих пассажиров'),
                           default=u'', max_length=255, blank=True, add_local_field=True)

    objects = PrecachingManager(iexact_keys=['sirena_id', 'iata', 'icao', 'icao_ru', 'express_code'])
    hidden_manager = HiddenManagerWrapper('objects')

    @property
    def type(self):
        warnings.warn("[2017-02-17] Don't use company.type.", RaspDeprecationWarning, stacklevel=2)
        return 'company'

    def __unicode__(self):
        return u'<Company: {} {}>'.format(self.id, self.title)

    class Meta(object):
        verbose_name = _(u'Компания-перевозчик')
        verbose_name_plural = _(u'Компании-перевозчики')
        permissions = (('can_delete_company_routes', u'Можно удалять рейсы компании'),)
        app_label = 'www'
        db_table = 'www_company'
