# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.fields import TrimmedCharField


class ExpressTypeLite(models.Model):
    title = TrimmedCharField(_(u'Название'), max_length=100, null=False, blank=True, default='')
    code = TrimmedCharField(_(u'Код'), max_length=40, null=False, blank=True, default='')
    color = TrimmedCharField(_(u'Цвет'), max_length=10, null=False, blank=True, default='')

    def __unicode__(self):
        return self.title

    class Meta(object):
        verbose_name = _(u'подтип экспрессов')
        verbose_name_plural = _(u'подтипы экспрессов')
        app_label = 'www'
        db_table = 'www_expresstypelite'
