# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.precache.manager import PrecachingManager
from travel.rasp.library.python.common23.db.caching import cache_until_switch


class RThreadType(models.Model):
    """ Тип нитки: ОСН, ТРАФ, .. """

    BASIC_ID = 1
    THROUGH_TRAIN_ID = 3
    CHANGE_ID = 9
    CANCEL_ID = 10
    ASSIGNMENT_ID = 11
    INTERVAL_ID = 12
    PSEUDO_BACK_ID = 13

    title = models.CharField(verbose_name=_(u'наименование'), max_length=100)
    code = models.CharField(verbose_name=_(u'код'), max_length=100, unique=True)

    objects = PrecachingManager(keys=['pk', 'code'])

    def __unicode__(self):
        return self.title

    @classmethod
    @cache_until_switch
    def get_by_code(cls, code):
        return RThreadType.objects.get(code=code)

    class Meta(object):
        verbose_name = _(u'тип нитки')
        verbose_name_plural = _(u'типы ниток')
        ordering = ('id',)
        app_label = 'www'
        db_table = 'www_rthreadtype'
