# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.functional import cached_property
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.core.directions.direction_from_translate import DirectionFromTranslate
from travel.rasp.library.python.common23.models.core.schedule.rtstation_logic_mixin import RTStationLogicMixin
from travel.rasp.library.python.common23.models.fields import TrimmedCharField


class RTStation(RTStationLogicMixin, models.Model):
    """ Станция нитки """

    tz_arrival = models.IntegerField(null=True, blank=True,
                                     help_text=_(u"расст. от нач. маршр. до приб. (в минутах)."
                                                 u" Прибытие на первую станцию заполнять нельзя(оставить пустым)"))
    tz_departure = models.IntegerField(null=True, blank=True,
                                       help_text=_(u"расст. от нач. маршр. до отпр. (в минутах)."
                                                   u" Отправление с последней станции заполнять"
                                                   u" нельзя(оставить пустым)"))
    time_zone = models.CharField(verbose_name=_(u'временная зона'), max_length=30)

    thread = models.ForeignKey('www.RThread', verbose_name=_(u"нитка"))
    station = models.ForeignKey('www.Station', verbose_name=_(u"станция"))
    arrival_code_sharing = models.BooleanField(verbose_name=_(u"прибытие code sharing"),
                                               null=False, blank=True, default=False)
    departure_code_sharing = models.BooleanField(verbose_name=_(u"отправление code sharing"),
                                                 null=False, blank=True, default=False)
    arrival_direction = models.ForeignKey('www.Direction', blank=True, null=True,
                                          verbose_name=_(u"arr_direction"),
                                          help_text=_(u"направление прибытия"),
                                          related_name='arrival_rtstation_set')
    departure_direction = models.ForeignKey('www.Direction', blank=True, null=True,
                                            verbose_name=_(u"dep_direction"),
                                            help_text=_(u"направление отправления"),
                                            related_name='departure_rtstation_set')
    arrival_subdir = models.CharField(verbose_name=_(u'arr_subdir'), max_length=100,
                                      null=True, blank=True)
    L_arrival_subdir = DirectionFromTranslate.get_L_method(key_field='arrival_subdir')
    departure_subdir = models.CharField(verbose_name=_(u'dep_subdir'), max_length=100,
                                        null=True, blank=True)
    L_departure_subdir = DirectionFromTranslate.get_L_method(key_field='departure_subdir')
    is_from_subdir = models.BooleanField(verbose_name=_(u"поднаправление \"туда\""),
                                         help_text=_(u"от Москвы"),
                                         null=False, blank=True, default=True)
    is_technical_stop = models.BooleanField(verbose_name=_(u"ТО"),
                                            help_text=_(u"техническая остановка"),
                                            null=False, blank=True, default=False)
    platform = TrimmedCharField(verbose_name=_(u'платформа'),
                                max_length=20, null=True, default=None, blank=True)

    terminal = models.ForeignKey('www.StationTerminal', verbose_name=_(u'терминал'),
                                 null=True, blank=True, default=None)

    arrival_t_model = models.ForeignKey('www.TransportModel', verbose_name=_(u"модель прибытия"),
                                        null=True, default=None, blank=True,
                                        related_name='arrival_rtstation_set')
    departure_t_model = models.ForeignKey('www.TransportModel', verbose_name=_(u"модель отправления"),
                                          null=True, default=None, blank=True,
                                          related_name='departure_rtstation_set')
    is_virtual_end = models.BooleanField(verbose_name=_(u"является виртуальной конечной остановкой"),
                                         null=False, blank=True, default=False)

    # fuzzy flags group
    is_fuzzy = models.BooleanField(_(u"нечеткое время отправления/прибытия"), default=False)
    is_searchable_to = models.BooleanField(_(u"искать до станции"), default=True)
    is_searchable_from = models.BooleanField(_(u"искать от станции"), default=True)
    in_station_schedule = models.BooleanField(_(u"в расписании по станции"), default=True)
    in_thread = models.BooleanField(_(u'показывать на странице нитки'), default=True)

    # next_station и prev_station заполнены только у самолетов. deprecated
    next_station = models.ForeignKey('www.Station', verbose_name=_(u"следующая станция"), null=True,
                                     related_name="rtstation_next_station_set")
    prev_station = models.ForeignKey('www.Station', verbose_name=_(u"предыдущая станция"), null=True,
                                     related_name="rtstation_prev_station_set")

    is_combined = models.BooleanField(_(u"Станция согласованной пересадки"), default=False)

    # только для поездов
    train_number = models.CharField(verbose_name=_(u'Номер поезда'), max_length=4, null=True, default='', blank=True)

    class Meta(object):
        verbose_name = _(u'станция нитки')
        verbose_name_plural = _(u'станции ниток')
        ordering = ('id',)
        app_label = 'www'
        db_table = 'www_rtstation'

    pytz = cached_property(RTStationLogicMixin.get_pytz)
