# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from future import standard_library
standard_library.install_aliases()
from builtins import map
from builtins import str
from builtins import range
import calendar
from collections import defaultdict
from datetime import timedelta

from travel.rasp.library.python.common23.models.core.schedule.rthread_type import RThreadType
from travel.rasp.library.python.common23.date import environment
from travel.rasp.library.python.common23.date.run_mask import RunMask
from travel.rasp.library.python.common23.date.date_const import MSK_TZ, MSK_TIMEZONE, KIEV_TZ, UTC_TZ  # noqa


def build_run_days(mask, from_date):
    result = defaultdict(dict)
    mask_str = str(mask)
    for month in range(1, 13):
        days = mask_str[(month - 1) * 31: month * 31]
        year = from_date.year if from_date.month <= month else from_date.year + 1
        last_day_idx = calendar.monthrange(year, month)[1]
        month_days = list(map(int, days[:last_day_idx]))
        if any(month_days):
            result[str(year)][str(month)] = month_days
    return result


def thread_run_days(thread, shift, days_ago):
    from_date = environment.now_aware().astimezone(thread.pytz).date() - timedelta(days_ago)
    mask = str(RunMask(thread.year_days, from_date).shifted(shift))
    return build_run_days(mask, from_date)


def calculate_run_days(segment, days_ago=0, result_timezone=None):
    """
    Возвращает календарь дней хождения нитки в виде:
    {
        '2016': {
            '1': [1, 0, 0, 1, 1, ...],
            '2': [1, 0, 0, 1, 1, ...],
            '3': [1, 1, 1, 1, 1, ...],
            ...
            '12': [1, 0, 0, 0, 0, ...]
        }
    }
    Длина списка равна количеству дней соответствующего месяца.
    :param segment:
    :param days_ago: Смещение начала генерации календаря относительно текущей даты.
    :param result_timezone: Временная зона относительно которой считается смещение календаря.
    """
    # чтобы избежать лишних sql запросов при вычислении маски
    segment.rtstation_from.thread = segment.thread
    segment.rtstation_from.station = segment.station_from

    if segment.thread.type_id == RThreadType.INTERVAL_ID:
        shift = 0
    else:
        shift = segment.rtstation_from.calc_days_shift(
            event='departure',
            start_date=segment.start_date,
            event_tz=result_timezone)

    result = thread_run_days(segment.thread, shift, days_ago)
    return result
