# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import json
from datetime import time

from django.db import models
from django.utils import translation

from travel.rasp.library.python.common23.date.run_mask import RunMask
from travel.rasp.library.python.common23.models.core.schedule.rtstation import RTStation


class StationSchedule(models.Model):
    station = models.ForeignKey('Station')
    route = models.ForeignKey('Route')
    thread = models.ForeignKey('RThread', null=True)
    rtstation = models.OneToOneField(RTStation, related_name='schedule')

    stops = models.TextField(null=True)
    stops_translations = models.TextField(null=True)

    is_fuzzy = models.BooleanField(default=False)

    def L_stops(self):
        if not getattr(self, 'stops_translations', None):
            return ''

        lang = translation.get_language()

        stops = json.loads(self.stops_translations)

        if lang in stops:
            return stops[lang]

        return ''

    @classmethod
    def get(cls, station, thread, event):
        # Получить расписание треда по станции
        schedule_set = cls.objects.filter(station=station, thread=thread)

        try:
            if event == 'departure':
                return schedule_set.order_by('rtstation__id')[0]

            return schedule_set.order_by('-rtstation__id')[0]

        except IndexError:
            raise cls.DoesNotExist("No StationSchedule matching query exists")

    def times(self, event):
        if not getattr(self, "%s_times" % event):
            # не отправляется или не прибывает на эту станцию
            return []

        return sorted(time(int(t) // 60, int(t) % 60) for t in getattr(self, "%s_times" % event).split(","))

    def mask(self, event, today=None):
        return RunMask(getattr(self, "%s_mask" % event), today=today)

    def __unicode__(self):
        return u'id=%s' % self.id

    class Meta(object):
        app_label = 'www'
