# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from itertools import groupby

from django.db import models
from django.utils.translation import ugettext_lazy as _


class TrainPurchaseNumber(models.Model):
    thread = models.ForeignKey('www.RThread', null=False, blank=False, verbose_name=_('нитка'),
                               on_delete=models.deletion.CASCADE)
    number = models.CharField(verbose_name=_('номер'), max_length=100, db_index=True, null=False)

    @classmethod
    def get_train_purchase_numbers(cls, threads):
        """
        для некоторых электричек, мы можем продавать билеты через АПИ поездов,
        функция позволяет получить нужные для продажи номера, сгруппированные по массиву ниток.
        :param threads: массив ниток
        :return: dict{thread_id: [number,]}
        """
        result = {}
        for thread_id, row in groupby(
            cls.objects.filter(thread_id__in=[t.id for t in threads]).order_by('thread_id').values('thread_id',
                                                                                                   'number'),
            key=lambda v: v['thread_id']
        ):
            result[thread_id] = [r['number'] for r in row]
        return result

    class Meta(object):
        verbose_name = _('Номер поезда для продажи')
        verbose_name_plural = _('Номера поездов для продажи')
        app_label = 'www'
        db_table = 'www_trainpurchasenumber'
        unique_together = ('thread', 'number')
