PY23_LIBRARY()
OWNER(g:rasp-back)

PEERDIR(
    contrib/python/django/django-1.11
    contrib/python/future
    contrib/python/Unidecode

    travel/rasp/library/python/common23/db
    travel/rasp/library/python/common23/db/mds
    travel/rasp/library/python/common23/models/currency
    travel/rasp/library/python/common23/models/fields
    travel/rasp/library/python/common23/models/precache
    travel/rasp/library/python/common23/models/texts
    travel/rasp/library/python/common23/models/tariffs
    travel/rasp/library/python/common23/models/transport
    travel/rasp/library/python/common23/models/utils
    travel/rasp/library/python/common23/models/www
    travel/rasp/library/python/common23/settings
    travel/rasp/library/python/common23/utils
    travel/rasp/library/python/common23/date
)


PY_SRCS(
    models.py

    directions/direction.py
    directions/direction_from_translate.py
    directions/direction_marker.py
    directions/direction_translate.py
    directions/external_direction.py
    directions/external_direction_marker.py
    directions/schema.py
    directions/station2direction.py

    geo/base_district.py
    geo/base_settlement_image.py
    geo/base_station.py
    geo/city_majority.py
    geo/code_system.py
    geo/const.py
    geo/country.py
    geo/district.py
    geo/express2country.py
    geo/point.py
    geo/point_synonym.py
    geo/point_slugs.py
    geo/region.py
    geo/replace_exception.py
    geo/settlement.py
    geo/station.py
    geo/station_code.py
    geo/station_code_manager.py
    geo/station_phone.py
    geo/station_terminal.py
    geo/station_majority.py
    geo/station_type.py
    geo/suburban_zone.py
    geo/timezone_mixin.py
    geo/title_generator.py
    geo/translocal_mixin.py
    geo/way_to_airport.py

    schedule/avia_alliance.py
    schedule/base_route.py
    schedule/base_rthread.py
    schedule/base_supplier.py
    schedule/company.py
    schedule/express_type.py
    schedule/express_type_lite.py
    schedule/route.py
    schedule/route_ltitle.py
    schedule/rthread.py
    schedule/rthread_type.py
    schedule/rtstation.py
    schedule/rtstation_logic_mixin.py
    schedule/run_days.py
    schedule/station_schedule.py
    schedule/supplier.py
    schedule/train_purchase_number.py
    schedule/train_schedule_plan.py
)

RESOURCE_FILES(
    PREFIX travel/rasp/library/python/common23/models/core/

    # fixtures
    fixtures/02_www_stationtype_initial.json
    fixtures/www_citymajority_initial.json
    fixtures/www_codesystem_initial.json
    fixtures/www_country_initial.json
    fixtures/www_rthreadtype_initial.json
    fixtures/www_settlement_initial.json
    fixtures/www_stationmajority_initial.json
)

END()


RECURSE_FOR_TESTS(tests)
