# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.core.files.storage import FileSystemStorage
from django.core.files.storage import get_storage_class
from travel.rasp.library.python.common23.utils.text import transliterate


class TransliteratingFileSystemStorage(FileSystemStorage):
    def get_valid_name(self, name):
        valid_name = super(TransliteratingFileSystemStorage, self).get_valid_name(name)
        valid_name = transliterate(valid_name, 'cyr-lat')

        return valid_name


class ReplaceableFileSystemStorage(get_storage_class()):
    def get_available_name(self, name):
        if self.exists(name):
            self.delete(name)

        return name
