# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function


def get_slots_proxyficator(model_class):
    """
    Наружу торчит прокси.
    При запросе аттрибута, если он должен быть в прокси, он берется от туда, иначе идет в модель.
    В модели храним только ссылку на прокси, остальное берется из класса.
    """

    slots_set = set(['__dict__', '_state'] + [f.attname for f in model_class._meta.fields])
    shared_state = model_class()._state

    class ProxiedModel(model_class):
        def __init__(self):
            pass

        class Meta(object):
            proxy = True
            # Джанга кешурует метакласс и все становится плохо, потому генерируем уникальный app_label
            app_label = '{}_{}_slots_proxy'.format(model_class._meta.app_label, model_class.__name__.lower())

    if hasattr(model_class, '__getattr__'):
        def __getattr(self, attname):
            try:
                return getattr(self._slots_proxy, attname)
            except AttributeError:
                return super(ProxiedModel, self).__getattr__(attname)
    else:
        def __getattr(self, attname):
            try:
                return getattr(self._slots_proxy, attname)
            except AttributeError:
                raise AttributeError("'{}' object has no attribute '{}'".format(model_class.__name__, attname))

    def __setattr(self, attname, value):
        if attname in slots_set:
            setattr(self._slots_proxy, attname, value)
        else:
            super(self.__class__, self).__setattr__(attname, value)

    ProxiedModel.__name__ = 'Proxied' + model_class.__name__
    ProxiedModel.__getattr__ = __getattr
    ProxiedModel.__setattr__ = __setattr

    class ProxySlots(object):
        __slots__ = list(slots_set)

        def __init__(self, items):
            for k, v in items:
                setattr(self, k, v)

            self._state = shared_state

    ProxySlots.__name__ = 'ProxySlots' + model_class.__name__

    def proxyficator(obj):
        items = list(obj.__dict__.items())

        if not isinstance(obj, ProxiedModel):
            obj = ProxiedModel()

        ps = ProxySlots(items)

        obj.__dict__.clear()
        obj.__dict__['_slots_proxy'] = ps

        return obj

    return proxyficator
