# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from contextlib import contextmanager


class BasePrecacheStorage(object):
    _cache = None

    @classmethod
    def build_cache(cls):
        raise NotImplementedError

    @classmethod
    @contextmanager
    def using_precache(cls):
        if cls._cache is None:
            cls._cache = cls.build_cache()
            try:
                yield
            finally:
                cls._cache = None
        else:
            yield

    @classmethod
    def is_precached(cls):
        return cls._cache is not None
