# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import six
import marshmallow

from collections import namedtuple

MarshalResult = namedtuple('MarshalResult', ['data', 'errors'])
UnmarshalResult = namedtuple('UnmarshalResult', ['data', 'errors'])


class Schema(marshmallow.Schema):
    """
    Old marshmallow py2 interfaces on top of py3 interfaces
    """

    class Meta:
        unknown = marshmallow.EXCLUDE  # don't raise error on unknown fields

    def load_old(self, *args, **kwargs):
        if six.PY2:
            return super(Schema, self).load(*args, **kwargs)

        try:
            result = super(Schema, self).load(*args, **kwargs)
            return UnmarshalResult(result, {})
        except marshmallow.ValidationError as ex:
            return UnmarshalResult(ex.valid_data, ex.messages)

    def loads_old(self, *args, **kwargs):
        if six.PY2:
            return super(Schema, self).loads(*args, **kwargs)

        try:
            result = super(Schema, self).loads(*args, **kwargs)
            return UnmarshalResult(result, {})
        except marshmallow.ValidationError as ex:
            return UnmarshalResult(ex.valid_data, ex.messages)

    def dump_old(self, *args, **kwargs):
        if six.PY2:
            return super(Schema, self).dump(*args, **kwargs)

        try:
            result = super(Schema, self).dump(*args, **kwargs)
            return MarshalResult(result, {})
        except marshmallow.ValidationError as ex:
            return MarshalResult(ex.valid_data, ex.messages)

    def dumps_old(self, *args, **kwargs):
        if six.PY2:
            return super(Schema, self).dumps(*args, **kwargs)

        try:
            result = super(Schema, self).dumps(*args, **kwargs)
            return MarshalResult(result, {})
        except marshmallow.ValidationError as ex:
            return MarshalResult(ex.valid_data, ex.messages)
