# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import six

from django.db import models
from django.utils.functional import cached_property
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.currency.price import Price
from travel.rasp.library.python.common23.models.tariffs.tariff_type import TariffType


@six.python_2_unicode_compatible
class AeroexTariff(models.Model):
    """Тарифы аэроэкспрессов и электричек станция-станция"""

    station_from = models.ForeignKey('Station', verbose_name=_('первая станция'), related_name='aeroex_tariffs_from')
    station_to = models.ForeignKey('Station', verbose_name=_('последняя станция'), related_name='aeroex_tariffs_to')
    tariff = models.FloatField('Цена')
    suburban_search = models.BooleanField('В поиске электричек', default=True)
    reverse = models.BooleanField(verbose_name=_('туда-обратно'), blank=True, default=True)
    type = models.ForeignKey('TariffType', null=False, default=1, blank=False)
    precalc = models.BooleanField(verbose_name=_('Зонный'), blank=True, default=False)
    currency = models.CharField(_('Валюта'), max_length=10, null=True, default=None, blank=True)

    replace_tariff_type = models.ForeignKey(
        'TariffType', verbose_name=_('заменяющий тариф '), related_name='+', null=True, blank=True, default=None
    )

    @classmethod
    def zone_tariff(cls, tariff):
        t = cls()

        t.tariff = tariff
        t.type = TariffType.objects.get(code='etrain')

        return t

    @cached_property
    def price(self):
        return Price(self.tariff, self.currency)

    def __str__(self):
        return '<%s %s: %s>' % (self.__class__.__name__, self.type.code, self.tariff)

    class Meta(object):
        unique_together = [('station_from', 'station_to', 'type', 'precalc')]
        verbose_name = _('тариф пригородного транспорта точка-точка')
        verbose_name_plural = _('тарифы пригородного транспорта точка-точка')
        app_label = 'www'
