# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import six

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.texts.i18n import L_field


@six.python_2_unicode_compatible
class TariffGroup(models.Model):
    L_title = L_field(_(u'Название группы тарифов'), add_local_field=True, local_field_critical=True, max_length=100)

    TANKER_L_FIELDS = ['title']

    def __str__(self):
        return self.L_title()

    class Meta(object):
        verbose_name = _('Группа тарифов')
        verbose_name_plural = _('Группы тарифов')
        app_label = 'www'
