# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from builtins import str
import logging

from django.utils.encoding import force_bytes

from travel.rasp.library.python.common23.models.texts.i18n import L_field
from travel.rasp.library.python.common23.utils_db.geobase import geobase

log = logging.getLogger(__name__)


class Geobase_L_title(L_field):
    def contribute_to_class(self, cls, name):
        assert name == 'L_title'

        return super(Geobase_L_title, self).contribute_to_class(cls, name)

    def exact_linguistics(self, obj, lang, case):
        # Значения в базе имеют приоритет над геобазой
        super_form = super(Geobase_L_title, self).exact_linguistics(obj, lang, case)

        if super_form:
            return super_form

        if obj._geo_id:
            linguistics = self.get_geobase_linguistics(obj._geo_id, lang)
            if linguistics:
                value = getattr(linguistics, case, b'')
                return force_bytes(value).decode('utf-8') or None

        return None

    def get_geobase_linguistics(self, geo_id, lang):
        if geobase:
            try:
                return geobase.linguistics(geo_id, str(lang))
            except RuntimeError:
                log.warning('Не удалось получить локальные наименования для %s, язык %s', geo_id, lang)

        return None
