# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.precache.manager import PrecachingManager
from travel.rasp.library.python.common23.models.texts.i18n import L_field


class PlatformTranslation(models.Model):
    TANKER_L_FIELDS = ('platform',)
    TANKER_KEY_FIELD = 'platform'
    TANKER_HELP_FIELDS = ('description',)

    description = models.CharField(_(u'Где встречается'), max_length=255, null=True, default=None,
                                   blank=True)

    L_platform = L_field(_(u'платформа'), add_local_field=True, max_length=30, null=True,
                         default=None, blank=True)

    objects = PrecachingManager(keys=('platform',))

    def __unicode__(self):
        return u'Переводы платформы "{}"'.format(self.platform)

    @classmethod
    def get_translation(cls, platform, lang=None):
        platform = (platform or u'').strip()

        if not platform:
            return platform

        try:
            pt = cls.objects.filter(platform=platform)[0]

            return pt.L_platform(lang=lang)

        except IndexError:
            return platform

    class Meta(object):
        verbose_name = _(u'Перевод платформы')
        verbose_name_plural = _(u'Переводы платформ')
        app_label = 'www'
        db_table = 'www_platformtranslation'
