# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.utils.encoding import force_text, smart_str
from django.utils.translation import ugettext

from travel.rasp.library.python.common23.models.texts.i18n import L_field


def tankerupload(tanker, model, objects, field, keyset):
    keys = {}

    field_object = getattr(model, 'L_' + field)

    if hasattr(model, 'tanker_add_{}_filter'.format(field)):
        objects = getattr(model, 'tanker_add_{}_filter'.format(field))(objects)

    for obj in objects:
        translations = {}

        field_translations = getattr(obj, 'L_' + field)

        for lang, attname, form in field_translations.by_language():
            local_language = obj.get_local_language() if hasattr(obj, 'get_local_language') else field_object.base_lang

            if lang is None:
                lang = local_language or 'ru'

            if form:
                translations[lang] = {
                    "form": form,
                }

        if translations:
            context = [
                ugettext(field_object.verbose_name),
            ]

            for context_field in model.TANKER_L_FIELDS:
                context_field_obj = getattr(model, 'L_' + context_field)
                context_field_translations = getattr(obj, 'L_' + context_field)

                context.append('%s: "%s"' % (ugettext(context_field_obj.verbose_name),
                                             context_field_translations.base_value))

            tanker_context_help_fields = getattr(model, 'TANKER_HELP_FIELDS', [])
            if tanker_context_help_fields:
                context.append(u"")

                for help_field_name in getattr(model, 'TANKER_HELP_FIELDS', []):
                    help_field = model._meta.get_field(help_field_name)
                    help_value = getattr(obj, help_field_name)

                    context.append(u'%s: "%s"' % (ugettext(help_field.verbose_name), help_value))

            key_field_name = getattr(model, 'TANKER_KEY_FIELD', 'id')
            translation_key = force_text(getattr(obj, key_field_name))

            keys[translation_key] = {
                "info": {
                    "is_plural": False,
                    "context": '\n'.join(context)
                },

                "translations": translations
            }

    tanker.upload(keyset, keys, L_field.LANGUAGES)


def tankerdownload(tanker, objects, field, keyset):
    model = objects.model
    updated = 0

    print(smart_str(
        'Downloading %s[%s]' % (
            force_text(keyset),
            ','.join(force_text(lang) for lang in L_field.LANGUAGES),
        )
    ))

    keys = tanker.download(keyset, L_field.LANGUAGES)

    key_field_name = getattr(model, 'TANKER_KEY_FIELD', 'id')

    filter_kwargs = {'{}__in'.format(key_field_name): list(keys.keys())}
    objects = objects.filter(**filter_kwargs)

    for obj in objects:
        fields_updated = 0
        translation_key = force_text(getattr(obj, key_field_name))

        if translation_key not in keys:
            print(smart_str('Object %s has not translation in tanker' % translation_key))

            continue

        key = keys[translation_key]

        field_translations = getattr(obj, 'L_' + field)

        for lang, attname, form in field_translations.by_language():
            if lang is None:
                continue

            override = getattr(obj, attname + '_override', False)

            if not override:
                try:
                    translated_form = key['translations'][lang]['form'].strip()
                except KeyError:
                    continue

                if translated_form and translated_form != form:
                    print(smart_str("Old: [%s]" % form))
                    print(smart_str("New: [%s]" % translated_form))

                    setattr(obj, attname, translated_form)

                    updated += 1
                    fields_updated += 1

        if fields_updated:
            obj.save()

    print(smart_str(u'Updated %d objects' % updated))
