# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _, get_language

from travel.rasp.library.python.common23.db.mds.s3_storage import mds_s3_media_storage
from travel.rasp.library.python.common23.models.fields import CodeCharField
from travel.rasp.library.python.common23.models.precache.manager import PrecachingManager


class TransportModel(models.Model):
    """ Модель транспортного средства: Як-40, Ту-154, .. """

    title = models.CharField(verbose_name=_(u'наименование'), max_length=100)
    title_en = models.CharField(verbose_name=_(u'англ. наименование'),
                                default=u'', blank=True, max_length=100)
    t_type = models.ForeignKey('www.TransportType', verbose_name=_(u'тип'))
    t_subtype = models.ForeignKey('www.TransportSubtype', verbose_name=_(u'подтип'), default=None, blank=True,
                                  null=True)
    TYPES = (
        (None, _(u'')),
        ('standard', _(u'Стандартный')),
        ('wire', _(u'Широкофюзеляжный')),
        ('tight', _(u'Узкий салон')),
    )
    plane_body_type = models.CharField(
        verbose_name=_(u'тип фюзеляжности самолёта'),
        max_length=10, null=True, blank=True, choices=TYPES)
    is_propeller_flight = models.BooleanField(
        verbose_name=_(u'винтовой самолёт'), default=False)

    template_page = models.CharField(verbose_name=_(u'имя шаблона'),
                                     max_length=100, null=True, blank=True)
    code = CodeCharField(verbose_name=_(u'код'), max_length=10,
                         null=True, blank=True, default=None, unique=True)
    code_en = CodeCharField(verbose_name=_(u'код Английский'), max_length=10,
                            null=True, blank=True, default=None, unique=True)
    producer = models.ForeignKey('www.VehicleProducer', verbose_name=_(u'производитель'),
                                 null=True, blank=True, default=None)

    img = models.ImageField(verbose_name=_(u'фото ТС'),
                            storage=mds_s3_media_storage,
                            upload_to='data/transportmodel/img',
                            null=True, blank=True, default=None)
    background = models.ImageField(verbose_name=_(u'картинка для фона'),
                                   storage=mds_s3_media_storage,
                                   upload_to='data/transportmodel/background',
                                   null=True, blank=True, default=None)

    ttx = models.TextField(verbose_name=_(u'тТХ'),
                           null=True, blank=True, default=None)
    descr = models.TextField(verbose_name=_(u'описание'),
                             null=True, blank=True, default=None)
    is_cargo = models.BooleanField(verbose_name=_(u"грузовой"), blank=True,
                                   default=False)

    objects = PrecachingManager()

    def L_title(self, lang=None):
        lang = lang or get_language()

        return self.title if lang == 'ru' else self.title_en

    def __unicode__(self):
        return self.L_title()

    type = "transportmodel"

    class Meta(object):
        verbose_name = _(u'модель транспорта')
        verbose_name_plural = _(u'модели транспорта')
        app_label = 'www'
        db_table = 'www_transportmodel'
