# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.core.validators import RegexValidator
from django.db import models
from django.utils.translation import ugettext_lazy as _

from travel.rasp.library.python.common23.models.fields import TrimmedCharField
from travel.rasp.library.python.common23.models.precache.manager import PrecachingManager


class TransportSubtypeColor(models.Model):
    code_validator = RegexValidator(
        r'^[0-9a-zA-Z-]+$',
        _(u'В коде цвета могут учавствовать только английские буквы цифры и знак минус')
    )
    color_validator = RegexValidator(
        r'^#[0-9a-fA-F]{6}$',
        _(u'Цвет должен быть задан в формате #123456')
    )

    code = models.CharField(verbose_name=_(u'Код'), max_length=50, null=False, blank=False, unique=True,
                            validators=[code_validator])
    color = TrimmedCharField(_(u'Цвет'), max_length=10, null=False, blank=False, validators=[color_validator])

    objects = PrecachingManager(keys=['pk'])

    def __unicode__(self):
        return u'{} {}'.format(self.code, self.color)

    class Meta(object):
        verbose_name = _(u'Цвет подтипа транспорта')
        verbose_name_plural = _(u'Цвета подтипов транспорта')
        app_label = 'www'
