# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.db import models
from django.utils.translation import ugettext_lazy as _


class VehicleProducer(models.Model):
    """ Производитель ТС: Як, Ту, .. """

    title = models.CharField(verbose_name=_(u'наименование'), max_length=100)
    t_type = models.ForeignKey('TransportType', verbose_name=_(u'тип транспорта'))

    def __unicode__(self):
        return self.title

    def name(self):
        return self.__unicode__()

    type = "vehicleproducer"

    class Meta(object):
        verbose_name = _(u'производитель ТС')
        verbose_name_plural = _(u'производители ТС')
        ordering = ('title',)
        app_label = 'www'
        db_table = 'www_vehicleproducer'
