# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import traceback
from importlib import import_module

from django.conf import settings
from django.db.models import base

log = logging.getLogger(__name__)


class SwapModel(base.ModelBase):
    def __new__(cls, name, bases, attrs):
        # Хак для django.db.models.query_utils::deferred_class_factory:245
        if bases and name.startswith(u'{}_Deferred_'.format(bases[0].__name__)):
            admin_module_path = bases[0].admin_module_path
        else:
            admin_module_path = attrs['admin_module_path']

        if getattr(settings, 'RASP_PROJECT', None) == 'admin':
            try:
                module = import_module(admin_module_path)
            except ImportError as e:
                raise Exception('Can not import {}: {}\n{}'.format(admin_module_path, str(e), traceback.format_exc()))
            else:
                return getattr(module, name)

        return super(SwapModel, cls).__new__(cls, name, bases, attrs)
