# coding: utf8
# flake8: noqa
from __future__ import unicode_literals, absolute_import, division, print_function

from past.builtins import execfile
import os

try:
    activate_this = os.path.join(os.path.dirname(__file__), 'activate_this.py')
    execfile(activate_this, dict(__file__=activate_this))
except IOError as io_err:
    if io_err.errno == 2 and 'activate_this.py' in io_err.filename:
        pass  # no activate_this in Arcadia
    else:
        raise

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'local_settings')

from django.conf import settings
from django.core.wsgi import get_wsgi_application

application = get_wsgi_application()

# raven инициализируется при загрузке модуля models. Это должно происходить валидации
# моделей, но при запуске через gunicorn этого не происходит. Мануал рекомендует
# добавить вызов call_command('validate'), но мы не хотим, чтобы при старте приложения
# в продакшне проверялись все таблицы
import raven.contrib.django.raven_compat.models  # noqa

# ловим все ошибки
from raven.contrib.django.raven_compat.middleware.wsgi import Sentry
application = Sentry(application)

if settings.DEBUG:
    try:
        from werkzeug.debug import DebuggedApplication

        settings.DEBUG_PROPAGATE_EXCEPTIONS = True

        application = DebuggedApplication(application, evalex=True)
    except ImportError:
        pass
